/*
 * Diese Datei ist Teil des GDialog Projektes:
 * "Gigaset-Erweiterung fr ProjectX"
 * 
 * Das GDialog Projekt ist freigegeben unter
 * der GNU Public Licence (GPL), deren Text sich in
 * dem Quellen-Verzeichnis befindet. Ist er dort nicht
 * mehr vorhanden, so kann er unter http://www.gnu.org/licenses/gpl.html
 * eingesehen werden.
 */
package de.m740.projectx.gigaset;

import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/**
 * 
 * @author arnaud
 * 
 */
public abstract class GPanelAbstract extends JPanel implements GPanelTableIF {
    // ----------------------------------------------------------
    /**
     * File comparator A to Z
     */
    class FileComparatorAZ implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF) arg0;
                String tmpFN0 = tmpAufnahme.getOriginalTitel();
                tmpAufnahme = (GAufnahmeIF) arg1;
                String tmpFN1 = tmpAufnahme.getOriginalTitel();
                return tmpFN0.compareToIgnoreCase(tmpFN1);
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    /**
     * File comparator Z to A
     */
    class FileComparatorZA implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                return -(getFileComparatorAZ().compare(arg0, arg1));
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    /**
     * File comparator newer to older
     */
    class FileComparatorON implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF) arg0;
                String tmpFN0 = tmpAufnahme.getCridFilename();
                tmpAufnahme = (GAufnahmeIF) arg1;
                String tmpFN1 = tmpAufnahme.getCridFilename();
                return tmpFN0.compareTo(tmpFN1);
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    /**
     * File comparator newer to older
     */
    class FileComparatorNO implements Comparator {

        public int compare(Object arg0, Object arg1) {
            try {
                return -(getFileComparatorON().compare(arg0, arg1));
            } catch (Exception e) {
                // ignore
            }
            return 0;
        }

    }

    // ----------------------------------------------------------
    protected List aAufnahmen = null;

    protected GTableModel aTableModel = new GTableModel();

    protected GTable aTableAufnahmen = new GTable(aTableModel);

    protected JScrollPane spAufnahmen = new JScrollPane(aTableAufnahmen);

    private FileComparatorAZ aFileComparatorAZ = null;

    private FileComparatorZA aFileComparatorZA = null;

    private FileComparatorNO aFileComparatorNO = null;

    private FileComparatorON aFileComparatorON = null;
    
    protected int aSortSelector = SORT_FILES_NO;

    private GDialog aDialog = null;

    public GPanelAbstract() {
        super();
        initialize();
    }

    /**
     * 
     */
    private void initialize() {
        try {
            aTableAufnahmen.setDefaultRenderer(Object.class,
                    new GTableCellRenderer());
            // Font font = new Font("Monospaced", Font.PLAIN, 12);
            // aTableAufnahmen.setFont(font);
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    /**
     * @param inpIndex
     * @param inpAufnahme
     * @param inpHash
     */
    protected void addAufnahme(int inpIndex, GAufnahmeIF inpAufnahme,
            HashMap inpHash) {
        // doppelte Titel prfen ...
        String tmpTitel = inpAufnahme.getOriginalTitel();
        Object tmpObj = inpHash.get(tmpTitel);
        if (tmpObj instanceof GAufnahmeContainer) {
            GAufnahmeContainer tmpAufnahmeContainer = (GAufnahmeContainer) tmpObj;
            GAufnahmeIF tmpAufnahmeIF = tmpAufnahmeContainer.getAufnahme();
            tmpAufnahmeIF.setSerie(true);
            inpAufnahme.setSerie(true);
            tmpAufnahmeContainer.addChild(inpAufnahme);
        } else {
            // ... und Doubletten nummerieren
            GAufnahmeContainer tmpAufnahmeContainer = new GAufnahmeContainer(
                    inpAufnahme);
            inpHash.put(tmpTitel, tmpAufnahmeContainer);
            // push to table
            int row = aTableModel.getRowCount();
            aTableModel.addRow(tmpAufnahmeContainer);
            aTableModel.fireTableRowsInserted(row, row);
        }
    }

    /**
     * 
     * number children from old to newer
     */
    public void countChildren(int selector) {
        int anza = (aTableModel == null) ? 0 : aTableModel.getRowCount();
        for (int i = 0; i < anza; i++) {
            Object tmpObject = aTableModel.getObjectAtRow(i);
            if (tmpObject instanceof GAufnahmeContainer) {
                ((GAufnahmeContainer) tmpObject).countChildren(selector);
            }
        } // for i
    }

    /**
     * 
     * 
     */
    private void sortiereAufnahmen(Comparator inpComparator) {
        clearSelection();
        aTableModel.clear();
        aTableModel.fireTableDataChanged();
        fireStateChanged();
        //
        int anza = (aAufnahmen == null) ? 0 : aAufnahmen.size();
        if (anza > 1) {
            Collections.sort(aAufnahmen, inpComparator);
        }
        HashMap tmpHash = new HashMap(anza);
        for (int i = 0; i < anza; i++) {
            try {
                GAufnahmeIF tmpAufnahme = (GAufnahmeIF) aAufnahmen.get(i);
                addAufnahme(i, tmpAufnahme, tmpHash);
            } catch (Exception exc) {
                GConsole.setErrorMessage(exc);
            }
        } // for i
        // evtl letzte Tree-nderungen sichtbar machen
        aTableModel.fireTableRowsUpdated(0, aTableModel.getRowCount() - 1);
        tmpHash = null;

        if (aTableModel.getRowCount() == 0) {
            // falls keine Aufnahmen vorh.
            getDialog().zeigeInfos(-1); // soll auch nix angezeigt w.!
        }
    }

    /**
     * 
     * 
     */
    public void sortiereAufnahmen(int selector) {
        try {
            switch (selector) {
            case SORT_FILES_AZ:
                sortiereAufnahmen(getFileComparatorAZ());
                break;
            case SORT_FILES_ZA:
                sortiereAufnahmen(getFileComparatorZA());
                break;
            case SORT_FILES_NO:
                sortiereAufnahmen(getFileComparatorNO());
                break;
            case SORT_FILES_ON:
                sortiereAufnahmen(getFileComparatorON());
                break;
            }
        } catch (RuntimeException exc) {
            GConsole.setErrorMessage(exc);
        }
    }

    public GAufnahmeIF getSelectedAufnahme() {
        try {
            if (aTableAufnahmen == null || aTableModel == null) {
                return null;
            }
            int nr = aTableAufnahmen.getSelectedRow();
            if (nr < 0) {
                return null;
            }
            return aTableModel.getAufnahmeAtRow(nr);
        } catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
        return null; // error
    }

    /**
     * 
     */
    public int readSelectedAufnahme() {
        try {
            int nr = aTableAufnahmen.getSelectedRow();
            if (nr < 0) {
                return -1;
            }
            GAufnahmeIF tmpAufnahme = aTableModel.getAufnahmeAtRow(nr);
            tmpAufnahme.readAufnahme();
            return nr;
        } catch (Exception e) {
            GConsole.setErrorMessage(e);
        }
        return -1; // error
    }

    public String getSelectedExtension() {
        GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
        if (tmpAufnahme == null) {
            return null;
        }
        return tmpAufnahme.getExtension();
    }

    public String getSelectedOutname() {
        String tmpString = getSelectedTitel();
        // wenn ein Punkt im Titel ist,
        // dann noch die Extension anhngen,
        // weil sonst PjX den letzten Teil abschneidet
        if (tmpString != null && tmpString.indexOf('.') >= 0) {
            String tmpString2 = getSelectedExtension();
            if (tmpString2 != null) {
                tmpString += tmpString2;
            }
        }
        return tmpString;
    }

    public String getSelectedTitel() {
        GAufnahmeIF tmpAufnahme = getSelectedAufnahme();
        if (tmpAufnahme == null) {
            return null;
        }
        return tmpAufnahme.getTitel();
    }

    protected String shortPathOf(String inpPath) {
        if (inpPath == null) {
            return "";
        }
        char tmpC = File.separatorChar;
        int x1 = inpPath.indexOf(tmpC);
        String tmpString = "";
        if (x1 > 0) {
            int len = inpPath.length();
            tmpString += inpPath.substring(0, x1 + 1);
            inpPath = (len - 1 == x1) ? "" : inpPath.substring(x1 + 1);
        }
        int x2 = inpPath.lastIndexOf(File.separatorChar);
        tmpString += (x2 == x1 || x2 < 0) ? inpPath : "..."
                + inpPath.substring(x2);
        return tmpString;
    }

    /**
     * Adds a <code>ChangeListener</code> to this tabbedpane.
     * 
     * @param l
     *            the <code>ChangeListener</code> to add
     * @see #fireStateChanged
     * @see #removeChangeListener
     */
    public void addChangeListener(ChangeListener l) {
        removeChangeListener(l); // prevent double listening!
        listenerList.add(ChangeListener.class, l);
    }

    /**
     * Removes a <code>ChangeListener</code> from this tabbedpane.
     * 
     * @param l
     *            the <code>ChangeListener</code> to remove
     * @see #fireStateChanged
     * @see #addChangeListener
     */
    public void removeChangeListener(ChangeListener l) {
        listenerList.remove(ChangeListener.class, l);
    }

    /**
     * Sends a <code>ChangeEvent</code>, whose source is this tabbedpane, to
     * each listener. This method method is called each time a
     * <code>ChangeEvent</code> is received from the model.
     * 
     * @see #addChangeListener
     * @see EventListenerList
     */
    protected void fireStateChanged() {
        // Guaranteed to return a non-null array
        Object[] listeners = listenerList.getListenerList();
        // Process the listeners last to first, notifying
        // those that are interested in this event
        ChangeEvent tmpChangeEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == ChangeListener.class) {
                // Lazily create the event:
                if (tmpChangeEvent == null)
                    tmpChangeEvent = new ChangeEvent(this);
                ((ChangeListener) listeners[i + 1])
                        .stateChanged(tmpChangeEvent);
            }
        }
    }

    protected GDialog getDialog() {
        return aDialog;
    }

    protected void setDialog(GDialog inpDialog) {
        aDialog = inpDialog;
    }

    protected void clearSelection() {
        aTableAufnahmen.getSelectionModel().clearSelection();
    }

    /**
     * 
     */
    private void actionDone(boolean inpOK) {
        if (!inpOK) {
            clearSelection();
        }
        getDialog().actionDone(inpOK, true);
    }

    private boolean isExpander() {
        boolean ok = false;
        try {
            if (aTableAufnahmen == null || aTableModel == null) {
                return ok;
            }
            int nr = aTableAufnahmen.getSelectedRow();
            if (nr < 0) {
                return ok;
            }
            Object tmpObject = aTableModel.getObjectAtRow(nr);
            if (tmpObject instanceof GAufnahmeContainer) {
                GAufnahmeContainer tmpContainer = (GAufnahmeContainer) tmpObject;
                if (!tmpContainer.hasChildren()) {
                    return false;
                }
                ok = true;
                if (tmpContainer.isExpanded()) {
                    // collapse node
                    List tmpList = tmpContainer.getDoubles();
                    int anz = (tmpList == null) ? 0 : tmpList.size();
                    int i;
                    for (i = 0; i < anz; i++) {
                        GAufnahmeContainer tmpDouble = (GAufnahmeContainer) tmpList
                                .get(0);
                        aTableModel.removeRow(tmpDouble);
                        tmpContainer.removeDouble(tmpDouble);
                    } // for i
                    aTableModel.fireTableRowsDeleted(nr + 1, nr + i);
                } else {
                    // expand node
                    List tmpList = tmpContainer.getChildren();
                    int anz = (tmpList == null) ? 0 : tmpList.size();
                    int r = nr;
                    for (int i = 0; i < anz; i++) {
                        GAufnahmeIF tmpAufnahme = (GAufnahmeIF) tmpList.get(i);
                        GAufnahmeContainer tmpDouble = new GAufnahmeContainer(
                                tmpAufnahme);
                        aTableModel.addRow(++r, tmpDouble);
                        tmpContainer.addDouble(tmpDouble);
                    } // for i
                    aTableModel.fireTableRowsInserted(nr + 1, r);
                }
            }
        } catch (Exception exc) {
            GConsole.setErrorMessage(exc);
        }
        return ok;
    }

    protected void mouseClick(MouseEvent event) {
        int clicks = event.getClickCount();
        int x = event.getX();
        if (event.getButton() == 1 && clicks == 2 && x > 22) {
            actionDone(true);
        } else if (clicks == 1 & x < 21) {
            if (isExpander()) {
                return;
            }
        }
    }

    /**
     * @return comparatorAZ
     */
    protected FileComparatorAZ getFileComparatorAZ() {
        if (aFileComparatorAZ == null) {
            aFileComparatorAZ = new FileComparatorAZ();
        }
        return aFileComparatorAZ;
    }

    /**
     * @return fileComparatorZA
     */
    private FileComparatorZA getFileComparatorZA() {
        if (aFileComparatorZA == null) {
            aFileComparatorZA = new FileComparatorZA();
        }
        return aFileComparatorZA;
    }

    /**
     * @return fileComparatorNO
     */
    private FileComparatorNO getFileComparatorNO() {
        if (aFileComparatorNO == null) {
            aFileComparatorNO = new FileComparatorNO();
        }
        return aFileComparatorNO;
    }

    /**
     * @return fileComparatorON
     */
    protected FileComparatorON getFileComparatorON() {
        if (aFileComparatorON == null) {
            aFileComparatorON = new FileComparatorON();
        }
        return aFileComparatorON;
    }

    /**
     * @return sortSelector
     */
    protected int getSortSelector() {
        return aSortSelector;
    }

    /**
     * @param inpSortSelector Festzulegender sortSelector
     */
    protected void setSortSelector(int inpSortSelector) {
        aSortSelector = inpSortSelector;
    }
}
